//GEMINI-pro DATASET v1.0 Category: Color Code Converter ; Style: complete
#include <stdio.h>
#include <stdlib.h>

// Hexadecimal to RGB conversion function
void hex_to_rgb(char *hex, int *r, int *g, int *b) {
    // Initialize variables
    *r = 0;
    *g = 0;
    *b = 0;

    // Check if the hexadecimal string is valid
    if (strlen(hex) != 6) {
        printf("Invalid hexadecimal string: %s", hex);
        exit(1);
    }

    // Convert the hexadecimal string to an integer
    int rgb = (int)strtol(hex, NULL, 16);

    // Extract the R, G, and B values from the integer
    *r = (rgb >> 16) & 0xFF;
    *g = (rgb >> 8) & 0xFF;
    *b = rgb & 0xFF;
}

// RGB to hexadecimal conversion function
char *rgb_to_hex(int r, int g, int b) {
    // Initialize variables
    char *hex = malloc(7);

    // Convert the RGB values to hexadecimal
    sprintf(hex, "#%02X%02X%02X", r, g, b);

    // Return the hexadecimal string
    return hex;
}

// Main function
int main() {
    // Initialize variables
    char hex[] = "FFFFFF";
    int r, g, b;

    // Convert the hexadecimal string to RGB values
    hex_to_rgb(hex, &r, &g, &b);

    // Print the RGB values
    printf("R: %d, G: %d, B: %d\n", r, g, b);

    // Convert the RGB values to a hexadecimal string
    char *new_hex = rgb_to_hex(r, g, b);

    // Print the hexadecimal string
    printf("New Hexadecimal String: %s\n", new_hex);

    // Free the allocated memory
    free(new_hex);

    return 0;
}