//Gemma-7B DATASET v1.0 Category: Simulation of the Solar System ; Style: sophisticated
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#define NUM_PLANETS 8

typedef struct Planet {
  char name[20];
  double mass;
  double x;
  double y;
  double z;
  double vx;
  double vy;
  double vz;
} Planet;

Planet planets[NUM_PLANETS] = {
  {"Mercury", 0.055, 0.25, 0.0, 0.0, 0.2, 0.0, 0.0},
  {"Venus", 0.815, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
  {"Earth", 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
  {"Mars", 0.105, 1.52, 0.0, 0.0, 0.0, 0.0, 0.0},
  {"Jupiter", 5.9e-3, -5.2, 0.0, 0.0, 1.0, 0.0, 0.0},
  {"Saturn", 5.8e-3, -8.0, 0.0, 0.0, 0.0, 0.0, 0.0},
  {"Uranus", 1.0e-3, -11.0, 0.0, 0.0, 0.0, 0.0, 0.0},
  {"Neptune", 1.0e-3, -14.0, 0.0, 0.0, 0.0, 0.0, 0.0}
};

void simulate_solar_system() {
  for (int i = 0; i < NUM_PLANETS; i++) {
    planets[i].x += planets[i].vx * 0.01;
    planets[i].y += planets[i].vy * 0.01;
    planets[i].z += planets[i].vz * 0.01;
  }

  for (int i = 0; i < NUM_PLANETS; i++) {
    double distance = sqrt(planets[i].x * planets[i].x + planets[i].y * planets[i].y + planets[i].z * planets[i].z);
    planets[i].vx *= distance;
    planets[i].vy *= distance;
    planets[i].vz *= distance;
  }
}

int main() {
  simulate_solar_system();

  for (int i = 0; i < NUM_PLANETS; i++) {
    printf("%s: (%f, %f, %f)\n", planets[i].name, planets[i].x, planets[i].y, planets[i].z);
  }

  return 0;
}