//Code Llama-13B DATASET v1.0 Category: Matrix operations ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stdbool.h>

#define MATRIX_ROWS 3
#define MATRIX_COLS 3

typedef struct {
    int rows;
    int cols;
    int data[MATRIX_ROWS][MATRIX_COLS];
} Matrix;

Matrix create_matrix(int rows, int cols) {
    Matrix matrix;
    matrix.rows = rows;
    matrix.cols = cols;
    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            matrix.data[i][j] = 0;
        }
    }
    return matrix;
}

void print_matrix(Matrix matrix) {
    for (int i = 0; i < matrix.rows; i++) {
        for (int j = 0; j < matrix.cols; j++) {
            printf("%d ", matrix.data[i][j]);
        }
        printf("\n");
    }
}

Matrix add_matrix(Matrix matrix1, Matrix matrix2) {
    Matrix result = create_matrix(matrix1.rows, matrix1.cols);
    for (int i = 0; i < matrix1.rows; i++) {
        for (int j = 0; j < matrix1.cols; j++) {
            result.data[i][j] = matrix1.data[i][j] + matrix2.data[i][j];
        }
    }
    return result;
}

Matrix multiply_matrix(Matrix matrix1, Matrix matrix2) {
    Matrix result = create_matrix(matrix1.rows, matrix1.cols);
    for (int i = 0; i < matrix1.rows; i++) {
        for (int j = 0; j < matrix1.cols; j++) {
            result.data[i][j] = matrix1.data[i][j] * matrix2.data[i][j];
        }
    }
    return result;
}

Matrix transpose_matrix(Matrix matrix) {
    Matrix result = create_matrix(matrix.cols, matrix.rows);
    for (int i = 0; i < matrix.rows; i++) {
        for (int j = 0; j < matrix.cols; j++) {
            result.data[j][i] = matrix.data[i][j];
        }
    }
    return result;
}

Matrix rotate_matrix(Matrix matrix, int num_rotations) {
    Matrix result = create_matrix(matrix.rows, matrix.cols);
    for (int i = 0; i < matrix.rows; i++) {
        for (int j = 0; j < matrix.cols; j++) {
            result.data[(i + num_rotations) % matrix.rows][(j + num_rotations) % matrix.cols] = matrix.data[i][j];
        }
    }
    return result;
}

int main() {
    srand(time(NULL));

    Matrix matrix1 = create_matrix(MATRIX_ROWS, MATRIX_COLS);
    for (int i = 0; i < matrix1.rows; i++) {
        for (int j = 0; j < matrix1.cols; j++) {
            matrix1.data[i][j] = rand() % 10;
        }
    }
    print_matrix(matrix1);

    Matrix matrix2 = create_matrix(MATRIX_ROWS, MATRIX_COLS);
    for (int i = 0; i < matrix2.rows; i++) {
        for (int j = 0; j < matrix2.cols; j++) {
            matrix2.data[i][j] = rand() % 10;
        }
    }
    print_matrix(matrix2);

    Matrix result = add_matrix(matrix1, matrix2);
    print_matrix(result);

    result = multiply_matrix(matrix1, matrix2);
    print_matrix(result);

    result = transpose_matrix(matrix1);
    print_matrix(result);

    result = rotate_matrix(matrix1, 1);
    print_matrix(result);

    result = rotate_matrix(matrix1, 2);
    print_matrix(result);

    return 0;
}