//Falcon-180B DATASET v1.0 Category: Networking ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>

#define SERVER_PORT 8080
#define BUFFER_SIZE 1024

// Function to print error message and exit
void error(char *message) {
    perror(message);
    exit(1);
}

// Function to print usage instructions
void usage() {
    printf("Usage:./program [host] [port]\n");
}

int main(int argc, char *argv[]) {
    if (argc < 3) {
        usage();
        return 1;
    }

    // Create socket
    int socket_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (socket_fd == -1) {
        error("socket");
    }

    // Set socket options
    int opt = 1;
    setsockopt(socket_fd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt));

    // Resolve hostname and port
    struct addrinfo *server_info;
    memset(&server_info, 0, sizeof(server_info));
    server_info->ai_family = AF_INET;
    server_info->ai_socktype = SOCK_STREAM;
    server_info->ai_protocol = IPPROTO_TCP;

    if (getaddrinfo(argv[1], argv[2], &server_info, NULL)!= 0) {
        error("getaddrinfo");
    }

    // Connect to server
    if (connect(socket_fd, server_info->ai_addr, server_info->ai_addrlen) == -1) {
        error("connect");
    }

    // Send data to server
    char send_buffer[BUFFER_SIZE];
    memset(send_buffer, 'A', BUFFER_SIZE);

    if (send(socket_fd, send_buffer, BUFFER_SIZE, 0) == -1) {
        error("send");
    }

    // Receive data from server
    char recv_buffer[BUFFER_SIZE];
    memset(recv_buffer, 0, BUFFER_SIZE);

    if (recv(socket_fd, recv_buffer, BUFFER_SIZE, 0) == -1) {
        error("recv");
    }

    printf("Received data: %s\n", recv_buffer);

    // Close socket
    close(socket_fd);

    return 0;
}