//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100

typedef struct {
  char name[50];
  int quantity;
  float price;
} product;

product inventory[MAX_PRODUCTS];
int num_products = 0;

void add_product(char *name, int quantity, float price) {
  if (num_products < MAX_PRODUCTS) {
    strcpy(inventory[num_products].name, name);
    inventory[num_products].quantity = quantity;
    inventory[num_products].price = price;
    num_products++;
  } else {
    printf("Inventory is full!\n");
  }
}

void print_inventory() {
  for (int i = 0; i < num_products; i++) {
    printf("%s: %d, %.2f\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
  }
}

void delete_product(char *name) {
  for (int i = 0; i < num_products; i++) {
    if (strcmp(inventory[i].name, name) == 0) {
      for (int j = i + 1; j < num_products; j++) {
        inventory[j - 1] = inventory[j];
      }
      num_products--;
      break;
    }
  }
}

int main() {
  // Linus Torvalds style:
  printf("I'm not sorry for this mess.\n");

  // Add some products to the inventory:
  add_product("A", 10, 10.0);
  add_product("B", 20, 20.0);
  add_product("C", 30, 30.0);

  // Print the inventory:
  printf("Inventory:\n");
  print_inventory();

  // Delete a product from the inventory:
  printf("Deleting product: A\n");
  delete_product("A");

  // Print the inventory again:
  printf("\nUpdated inventory:\n");
  print_inventory();

  return 0;
}