//GEMINI-pro DATASET v1.0 Category: Network Packet Monitoring ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>

// Callback function to handle each captured packet
void packet_handler(u_char *user, const struct pcap_pkthdr *pcap_header, const u_char *packet) {
    // Print some details about the captured packet
    printf("Packet captured! Length: %d bytes\n", pcap_header->len);

    // Peek into the first few bytes of the packet to see if it's an IP packet
    if (packet[0] == 0x08 && packet[1] == 0x00) {
        printf("It's an IPv4 packet!\n");

        // Extract the IP addresses and print them
        char src_ip[16], dst_ip[16];
        snprintf(src_ip, sizeof(src_ip), "%d.%d.%d.%d", packet[14], packet[15], packet[16], packet[17]);
        snprintf(dst_ip, sizeof(dst_ip), "%d.%d.%d.%d", packet[18], packet[19], packet[20], packet[21]);
        printf("Source IP: %s\n", src_ip);
        printf("Destination IP: %s\n", dst_ip);
    } else if (packet[0] == 0x86 && packet[1] == 0xdd) {
        printf("It's an IPv6 packet!\n");
    } else {
        printf("Unknown packet type.\n");
    }

    // Print a newline for clarity
    printf("\n");
}

int main() {
    // Open a live pcap capture session on the first network interface
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle = pcap_open_live(pcap_lookupdev(errbuf), 65535, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening live capture session: %s\n", errbuf);
        return EXIT_FAILURE;
    }

    // Set up a filter to capture only TCP packets
    struct bpf_program filter;
    if (pcap_compile(handle, &filter, "tcp", 1, 0) == -1) {
        fprintf(stderr, "Error compiling filter: %s\n", pcap_geterr(handle));
        pcap_close(handle);
        return EXIT_FAILURE;
    }
    if (pcap_setfilter(handle, &filter) == -1) {
        fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
        pcap_close(handle);
        return EXIT_FAILURE;
    }

    // Start capturing packets
    printf("Capturing TCP packets...\n");
    pcap_loop(handle, -1, packet_handler, NULL);

    // Clean up and exit
    pcap_close(handle);
    return EXIT_SUCCESS;
}