//Falcon-180B DATASET v1.0 Category: Expense Tracker ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100

struct item {
    char name[50];
    int cost;
    int quantity;
};

void add_item(struct item items[], int count, char name[], int cost, int quantity) {
    if (count >= MAX_ITEMS) {
        printf("Thou hast reached the limit of items thou canst add.\n");
        return;
    }
    strcpy(items[count].name, name);
    items[count].cost = cost;
    items[count].quantity = quantity;
    count++;
}

void display_items(struct item items[], int count) {
    printf("Items in thy inventory:\n");
    for (int i = 0; i < count; i++) {
        printf("%s - %d gold coins (%d)\n", items[i].name, items[i].cost, items[i].quantity);
    }
}

void remove_item(struct item items[], int count, char name[]) {
    int found = 0;
    for (int i = 0; i < count; i++) {
        if (strcmp(items[i].name, name) == 0) {
            found = 1;
            break;
        }
    }
    if (!found) {
        printf("Item not found in thy inventory.\n");
        return;
    }
    for (int i = 0; i < count - 1; i++) {
        strcpy(items[i].name, items[i + 1].name);
        items[i].cost = items[i + 1].cost;
        items[i].quantity = items[i + 1].quantity;
    }
    count--;
}

int main() {
    struct item items[MAX_ITEMS];
    int count = 0;

    add_item(items, count, "Sword", 100, 1);
    add_item(items, count, "Shield", 50, 1);
    add_item(items, count, "Helmet", 75, 1);

    display_items(items, count);

    remove_item(items, count, "Shield");

    display_items(items, count);

    return 0;
}