//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/types.h>

#define MAX_MSG_SIZE 1024

struct msg_buf {
    long mtype;
    char mtext[MAX_MSG_SIZE];
};

int main() {
    key_t key;
    int msgid;
    struct msg_buf msg;

    // Create a unique key for the message queue.
    key = ftok("sherlock.c", 0);
    if (key == -1) {
        perror("ftok");
        return 1;
    }

    // Create the message queue.
    msgid = msgget(key, IPC_CREAT | 0600);
    if (msgid == -1) {
        perror("msgget");
        return 1;
    }

    // Send a message to the message queue.
    msg.mtype = 1;
    snprintf(msg.mtext, sizeof(msg.mtext), "Elementary, my dear Watson.");
    if (msgsnd(msgid, &msg, sizeof(msg.mtext), 0) == -1) {
        perror("msgsnd");
        return 1;
    }

    // Receive a message from the message queue.
    if (msgrcv(msgid, &msg, sizeof(msg.mtext), 1, 0) == -1) {
        perror("msgrcv");
        return 1;
    }

    // Print the message.
    printf("Received message: %s\n", msg.mtext);

    // Delete the message queue.
    if (msgctl(msgid, IPC_RMID, NULL) == -1) {
        perror("msgctl");
        return 1;
    }

    return 0;
}