//GEMINI-pro DATASET v1.0 Category: Smart home light control ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LIGHTS 10

typedef struct {
    char name[32];
    int state; // 0 = off, 1 = on
} light;

light lights[MAX_LIGHTS];

void print_lights() {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        printf("%s: %s\n", lights[i].name, lights[i].state ? "on" : "off");
    }
}

void toggle_light(char *name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].state = !lights[i].state;
            return;
        }
    }
    printf("Light %s not found\n", name);
}

int main() {
    // Initialize lights
    strcpy(lights[0].name, "Living Room");
    lights[0].state = 0;
    strcpy(lights[1].name, "Kitchen");
    lights[1].state = 0;
    strcpy(lights[2].name, "Bedroom");
    lights[2].state = 0;

    // Print initial light states
    print_lights();

    // Toggle lights
    toggle_light("Living Room");
    toggle_light("Kitchen");

    // Print updated light states
    print_lights();

    return 0;
}