//Code Llama-13B DATASET v1.0 Category: Searching algorithm ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>

// Structure to store elements of the array
struct Element {
    int data;
    struct Element *next;
};

// Function to search for an element in the array
int search(struct Element *head, int key) {
    // Check if the head is NULL
    if (head == NULL) {
        return -1;
    }

    // Check if the head is the element we are looking for
    if (head->data == key) {
        return 0;
    }

    // Recursively search the rest of the array
    return search(head->next, key);
}

int main() {
    // Create an array of 10 elements
    struct Element array[10];

    // Initialize the array with random values
    for (int i = 0; i < 10; i++) {
        array[i].data = rand() % 100;
        array[i].next = &array[i + 1];
    }

    // Set the last element to NULL
    array[9].next = NULL;

    // Search for an element in the array
    int key = 10;
    int index = search(&array[0], key);

    // Print the index of the element if found, otherwise print -1
    if (index != -1) {
        printf("Element found at index %d\n", index);
    } else {
        printf("Element not found\n");
    }

    return 0;
}