//Falcon-180B DATASET v1.0 Category: Internet Speed Test Application ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <time.h>

#define MAX_DATA_SIZE 1024
#define SERVER_PORT 8080
#define SERVER_IP "speedtest.net"

int main() {
    int sockfd, bytes_sent, bytes_recv;
    struct sockaddr_in server_addr;
    char send_data[MAX_DATA_SIZE] = "GET / HTTP/1.1\r\nHost: speedtest.net\r\nConnection: close\r\n\r\n";
    char recv_data[MAX_DATA_SIZE];
    double start_time, end_time, total_time;

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        printf("Failed to create socket\n");
        exit(1);
    }

    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(SERVER_PORT);
    inet_pton(AF_INET, SERVER_IP, &server_addr.sin_addr);

    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        printf("Failed to connect to server\n");
        exit(1);
    }

    start_time = clock();
    bytes_sent = send(sockfd, send_data, strlen(send_data), 0);
    if (bytes_sent == -1) {
        printf("Failed to send data\n");
        exit(1);
    }

    bytes_recv = recv(sockfd, recv_data, MAX_DATA_SIZE, 0);
    if (bytes_recv == -1) {
        printf("Failed to receive data\n");
        exit(1);
    }

    end_time = clock();
    total_time = (end_time - start_time) / (double)CLOCKS_PER_SEC;
    printf("Total time taken: %lf seconds\n", total_time);

    close(sockfd);
    return 0;
}