//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

// Define the stock market tracker structure
typedef struct StockMarketTracker {
    char name[20];
    double currentPrice;
    double previousPrice;
    double change;
    double changePercentage;
} StockMarketTracker;

// Function to calculate the change percentage
double calculateChangePercentage(double currentPrice, double previousPrice) {
    double changePercentage = (currentPrice - previousPrice) / previousPrice * 100.0;
    return changePercentage;
}

// Function to update the stock market tracker
void updateStockMarketTracker(StockMarketTracker *tracker, double newPrice) {
    tracker->previousPrice = tracker->currentPrice;
    tracker->currentPrice = newPrice;
    tracker->change = newPrice - tracker->previousPrice;
    tracker->changePercentage = calculateChangePercentage(newPrice, tracker->previousPrice);
}

// Function to display the stock market tracker
void displayStockMarketTracker(StockMarketTracker *tracker) {
    printf("Name: %s\n", tracker->name);
    printf("Current Price: %.2lf\n", tracker->currentPrice);
    printf("Previous Price: %.2lf\n", tracker->previousPrice);
    printf("Change: %.2lf\n", tracker->change);
    printf("Change Percentage: %.2lf%\n", tracker->changePercentage);
}

int main() {
    // Create a stock market tracker
    StockMarketTracker tracker;
    strcpy(tracker.name, "Apple");
    tracker.currentPrice = 100.0;
    tracker.previousPrice = 95.0;

    // Update the stock market tracker
    updateStockMarketTracker(&tracker, 102.0);

    // Display the stock market tracker
    displayStockMarketTracker(&tracker);

    return 0;
}