//GEMINI-pro DATASET v1.0 Category: Database querying ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

// Define the maximum length of a SQL statement
#define SQL_STATEMENT_MAX_LENGTH 1024

// Define the maximum number of rows to return from a query
#define MAX_ROWS 100

// Define the maximum length of a column value
#define COLUMN_VALUE_MAX_LENGTH 1024

// Define the callback function for the sqlite3_exec() function
int callback(void *data, int argc, char **argv, char **azColName) {
    // Print the column names
    for (int i = 0; i < argc; i++) {
        printf("%s\t", azColName[i]);
    }
    printf("\n");

    // Print the row values
    for (int i = 0; i < argc; i++) {
        printf("%s\t", argv[i] ? argv[i] : "NULL");
    }
    printf("\n");

    return 0;
}

int main() {
    // Open the database
    sqlite3 *db;
    int rc = sqlite3_open("test.db", &db);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "Error opening database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Prepare the SQL statement
    char sql[SQL_STATEMENT_MAX_LENGTH];
    snprintf(sql, SQL_STATEMENT_MAX_LENGTH, "SELECT * FROM test_table WHERE id > %d", 10);

    // Execute the SQL statement
    rc = sqlite3_exec(db, sql, callback, NULL, NULL);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "Error executing SQL statement: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Close the database
    sqlite3_close(db);

    return 0;
}