//Falcon-180B DATASET v1.0 Category: Fractal Generation ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>
#include <GL/gl.h>

// Define the window size
#define WINDOW_WIDTH 800
#define WINDOW_HEIGHT 600

// Define the number of iterations
#define MAX_ITERATIONS 1000

// Define the colors
#define RED 0.5
#define GREEN 0.5
#define BLUE 0.5
#define WHITE 1.0

void display(void) {
    glClear(GL_COLOR_BUFFER_BIT);

    glColor3f(RED, GREEN, BLUE);
    glBegin(GL_LINE_STRIP);
    glVertex2f(0.0, 0.0);
    for (int i = 0; i < MAX_ITERATIONS; i++) {
        glVertex2f(i * WINDOW_WIDTH / MAX_ITERATIONS, i * WINDOW_HEIGHT / MAX_ITERATIONS);
    }
    glEnd();

    glColor3f(WHITE, WHITE, WHITE);
    glBegin(GL_LINE_STRIP);
    glVertex2f(0.0, 0.0);
    glVertex2f(WINDOW_WIDTH, 0.0);
    glVertex2f(WINDOW_WIDTH, WINDOW_HEIGHT);
    glVertex2f(0.0, WINDOW_HEIGHT);
    glEnd();

    glFlush();
}

void init(void) {
    glClearColor(0.0, 0.0, 0.0, 0.0);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(0.0, WINDOW_WIDTH, 0.0, WINDOW_HEIGHT);
}

void main(int argc, char **argv) {
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
    glutInitWindowSize(WINDOW_WIDTH, WINDOW_HEIGHT);
    glutInitWindowPosition(0, 0);
    glutCreateWindow("Fractal Generation");

    init();

    glutDisplayFunc(display);

    glutMainLoop();
}