//Code Llama-13B DATASET v1.0 Category: Music Library Management System ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SONGS 100

typedef struct {
    char title[50];
    char artist[50];
    int duration;
} Song;

void add_song(Song songs[], int *count, char *title, char *artist, int duration) {
    if (*count >= MAX_SONGS) {
        printf("Error: The maximum number of songs has been reached.\n");
        return;
    }

    strcpy(songs[*count].title, title);
    strcpy(songs[*count].artist, artist);
    songs[*count].duration = duration;
    (*count)++;
}

void remove_song(Song songs[], int *count, int index) {
    if (index < 0 || index >= *count) {
        printf("Error: Invalid index.\n");
        return;
    }

    for (int i = index; i < *count - 1; i++) {
        songs[i] = songs[i + 1];
    }
    (*count)--;
}

void display_songs(Song songs[], int count) {
    for (int i = 0; i < count; i++) {
        printf("Title: %s\nArtist: %s\nDuration: %d\n", songs[i].title, songs[i].artist, songs[i].duration);
    }
}

int main() {
    Song songs[MAX_SONGS];
    int count = 0;

    add_song(songs, &count, "Song 1", "Artist 1", 100);
    add_song(songs, &count, "Song 2", "Artist 2", 200);
    add_song(songs, &count, "Song 3", "Artist 3", 300);

    display_songs(songs, count);

    remove_song(songs, &count, 1);

    display_songs(songs, count);

    return 0;
}