//GPT-4o-mini DATASET v1.0 Category: Temperature monitor ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define TEMP_THRESHOLD_HIGH 75
#define TEMP_THRESHOLD_LOW 60
#define NUM_READINGS 10

void generate_temperature_readings(float *readings, int count) {
    for (int i = 0; i < count; i++) {
        readings[i] = (rand() % 2000) / 10.0; // Generate random temperature between 0 and 200 degrees
    }
}

void monitor_temperature(float *readings, int count) {
    for (int i = 0; i < count; i++) {
        printf("Reading %d: %.2f °C\n", i + 1, readings[i]);
        if (readings[i] > TEMP_THRESHOLD_HIGH) {
            printf("Alert! High temperature detected: %.2f °C\n", readings[i]);
        } else if (readings[i] < TEMP_THRESHOLD_LOW) {
            printf("Alert! Low temperature detected: %.2f °C\n", readings[i]);
        } else {
            printf("Temperature is in normal range.\n");
        }
        sleep(1); // Simulate a delay between readings
    }
}

void print_statistics(float *readings, int count) {
    float sum = 0;
    float max = readings[0];
    float min = readings[0];

    for (int i = 0; i < count; i++) {
        sum += readings[i];
        if (readings[i] > max) {
            max = readings[i];
        }
        if (readings[i] < min) {
            min = readings[i];
        }
    }
    float average = sum / count;
    printf("\nTemperature Statistics:\n");
    printf("Average Temperature: %.2f °C\n", average);
    printf("Maximum Temperature: %.2f °C\n", max);
    printf("Minimum Temperature: %.2f °C\n", min);
}

int main() {
    srand(time(NULL)); // Seed for random number generation
    float temperature_readings[NUM_READINGS];

    printf("Temperature Monitoring System\n");
    printf("Collecting %d temperature readings...\n", NUM_READINGS);

    generate_temperature_readings(temperature_readings, NUM_READINGS);
    monitor_temperature(temperature_readings, NUM_READINGS);
    print_statistics(temperature_readings, NUM_READINGS);

    return 0;
}