//Falcon-180B DATASET v1.0 Category: Browser Plugin ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <curl/curl.h>

#define BUFFER_SIZE 1024
#define USER_AGENT "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3"

struct string_t {
    char *ptr;
    size_t len;
};

size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp);

int main(int argc, char *argv[])
{
    if (argc < 2) {
        printf("Usage: %s <URL>\n", argv[0]);
        return 1;
    }

    CURL *curl;
    CURLcode res;
    struct string_t html;
    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if (curl) {
        curl_easy_setopt(curl, CURLOPT_URL, argv[1]);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, &html);
        curl_easy_setopt(curl, CURLOPT_USERAGENT, USER_AGENT);
        res = curl_easy_perform(curl);

        if (res!= CURLE_OK) {
            printf("curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
        } else {
            printf("HTML content:\n%s\n", html.ptr);
        }

        curl_easy_cleanup(curl);
        curl_global_cleanup();
    }

    return 0;
}

size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp)
{
    struct string_t *html = (struct string_t *)userp;
    size_t realsize = size * nmemb;
    html->ptr = realloc(html->ptr, html->len + realsize + 1);
    if (html->ptr == NULL) {
        return 0;
    }
    memcpy(&html->ptr[html->len], contents, realsize);
    html->len += realsize;
    html->ptr[html->len] = '\0';
    return realsize;
}