//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: Alan Turing
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define MAX_MSG_LEN 1024

typedef struct {
  long mtype;
  char mtext[MAX_MSG_LEN];
} message;

int main() {
  key_t key;
  int msgid;
  message msg;
  pid_t pid;

  // Create a message queue key
  key = ftok(".", 'a');

  // Create a message queue
  msgid = msgget(key, IPC_CREAT | 0666);

  // Fork a child process
  pid = fork();

  if (pid == 0) { // Child process
    // Send a message to the parent process
    msg.mtype = 1;
    sprintf(msg.mtext, "Hello from the child process!");
    msgsnd(msgid, &msg, sizeof(msg) - sizeof(long), 0);

    // Wait for a message from the parent process
    msgrcv(msgid, &msg, sizeof(msg) - sizeof(long), 2, 0);
    printf("Child received: %s\n", msg.mtext);
  } else { // Parent process
    // Wait for a message from the child process
    msgrcv(msgid, &msg, sizeof(msg) - sizeof(long), 1, 0);
    printf("Parent received: %s\n", msg.mtext);

    // Send a message to the child process
    msg.mtype = 2;
    sprintf(msg.mtext, "Hello from the parent process!");
    msgsnd(msgid, &msg, sizeof(msg) - sizeof(long), 0);

    // Wait for the child process to terminate
    wait(NULL);
  }

  // Remove the message queue
  msgctl(msgid, IPC_RMID, NULL);

  return 0;
}