//GEMINI-pro DATASET v1.0 Category: Queue Implementation ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

struct surreal_queue {
  int *data;
  int head;
  int tail;
  int size;
};

struct surreal_queue *surreal_queue_create(int size) {
  struct surreal_queue *queue = malloc(sizeof(struct surreal_queue));
  if (!queue) {
    return NULL;
  }

  queue->data = malloc(sizeof(int) * size);
  if (!queue->data) {
    free(queue);
    return NULL;
  }

  queue->head = 0;
  queue->tail = 0;
  queue->size = size;

  return queue;
}

void surreal_queue_destroy(struct surreal_queue *queue) {
  free(queue->data);
  free(queue);
}

int surreal_queue_is_empty(struct surreal_queue *queue) {
  return queue->head == queue->tail;
}

int surreal_queue_is_full(struct surreal_queue *queue) {
  return (queue->tail + 1) % queue->size == queue->head;
}

int surreal_queue_enqueue(struct surreal_queue *queue, int value) {
  if (surreal_queue_is_full(queue)) {
    return -1;
  }

  queue->data[queue->tail] = value;
  queue->tail = (queue->tail + 1) % queue->size;

  return 0;
}

int surreal_queue_dequeue(struct surreal_queue *queue) {
  if (surreal_queue_is_empty(queue)) {
    return -1;
  }

  int value = queue->data[queue->head];
  queue->head = (queue->head + 1) % queue->size;

  return value;
}

int main() {
  srand(time(NULL));

  struct surreal_queue *queue = surreal_queue_create(10);
  if (!queue) {
    return -1;
  }

  for (int i = 0; i < 10; i++) {
    int value = rand() % 100;
    printf("Enqueuing %d\n", value);
    surreal_queue_enqueue(queue, value);
  }

  printf("\n");

  while (!surreal_queue_is_empty(queue)) {
    int value = surreal_queue_dequeue(queue);
    printf("Dequeuing %d\n", value);
  }

  surreal_queue_destroy(queue);

  return 0;
}