//MISTRAL-7B DATASET v1.0 Category: Appointment Scheduler ; Style: recursive
#include <stdio.h>
#include <stdlib.h>

#define MAX_APPOINTMENTS 10
#define MIN_APPOINTMENT_DURATION 30
#define MAX_APPOINTMENT_DURATION 180

typedef struct {
    int start;
    int end;
    int duration;
} Appointment;

Appointment appointments[MAX_APPOINTMENTS];
int num_appointments = 0;

int is_appointment_valid(int start, int end, int duration) {
    for (int i = 0; i < num_appointments; i++) {
        if (appointments[i].start <= end && appointments[i].end >= start) {
            return 0;
        }
    }
    return 1;
}

void schedule_appointment(int start, int duration) {
    if (num_appointments >= MAX_APPOINTMENTS) {
        printf("Maximum number of appointments reached.\n");
        return;
    }

    if (start + MIN_APPOINTMENT_DURATION > MAX_APPOINTMENT_DURATION) {
        printf("Invalid appointment start or duration.\n");
        return;
    }

    if (!is_appointment_valid(start, start + duration, duration)) {
        printf("Conflicting appointment found.\n");
        return;
    }

    appointments[num_appointments].start = start;
    appointments[num_appointments].duration = duration;
    appointments[num_appointments].end = start + duration;
    num_appointments++;

    printf("Appointment scheduled from %d to %d.\n", start, start + duration);

    schedule_appointment(start + duration, MIN_APPOINTMENT_DURATION);
}

int main() {
    schedule_appointment(0, MIN_APPOINTMENT_DURATION);
    return 0;
}