//Falcon-180B DATASET v1.0 Category: Queue Implementation ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 100

// Queue representation using an array
struct Queue {
    int front;
    int rear;
    int arr[MAX_SIZE];
};

// Function to initialize the queue
void initQueue(struct Queue *q) {
    q->front = -1;
    q->rear = -1;
}

// Function to check if the queue is empty
int isEmpty(struct Queue *q) {
    if (q->front == -1 && q->rear == -1)
        return 1;
    else
        return 0;
}

// Function to check if the queue is full
int isFull(struct Queue *q) {
    if ((q->rear + 1) % MAX_SIZE == q->front)
        return 1;
    else
        return 0;
}

// Function to add an element to the queue
void enqueue(struct Queue *q, int data) {
    if (isFull(q))
        printf("Queue is full\n");
    else if (isEmpty(q)) {
        q->front = 0;
        q->rear = 0;
        q->arr[q->rear] = data;
    } else {
        q->rear = (q->rear + 1) % MAX_SIZE;
        q->arr[q->rear] = data;
    }
}

// Function to remove an element from the queue
int dequeue(struct Queue *q) {
    int data;
    if (isEmpty(q))
        printf("Queue is empty\n");
    else if (q->front == q->rear) {
        data = q->arr[q->front];
        q->front = -1;
        q->rear = -1;
    } else {
        data = q->arr[q->front];
        q->front = (q->front + 1) % MAX_SIZE;
    }
    return data;
}

// Function to display the contents of the queue
void display(struct Queue *q) {
    if (isEmpty(q))
        printf("Queue is empty\n");
    else {
        printf("Queue elements are:\n");
        int i;
        for (i = q->front; i <= q->rear; i = (i + 1) % MAX_SIZE)
            printf("%d ", q->arr[i]);
    }
}

int main() {
    struct Queue q;
    initQueue(&q);
    enqueue(&q, 10);
    enqueue(&q, 20);
    enqueue(&q, 30);
    display(&q);
    dequeue(&q);
    dequeue(&q);
    dequeue(&q);
    display(&q);
    return 0;
}