//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: romantic
#include <stdio.h>
#include <stdlib.h>

typedef struct {
    int passion;
    int intelligence;
    int beauty;
} Person;

// Compare two people based on their attractiveness
int comparePeople(const void *a, const void *b) {
    Person *p1 = (Person *)a;
    Person *p2 = (Person *)b;
    return (p1->passion + p1->intelligence + p1->beauty) - (p2->passion + p2->intelligence + p2->beauty);
}

// Find the most compatible pair of people from a group
Person *findCompatiblePair(Person *people, int n) {
    // Sort the people in descending order of attractiveness
    qsort(people, n, sizeof(Person), comparePeople);

    // Loop through each person
    for (int i = 0; i < n - 1; i++) {
        // Check if the current person is compatible with the next person
        if (people[i].passion > people[i+1].passion && people[i].intelligence > people[i+1].intelligence && people[i].beauty > people[i+1].beauty) {
            // Return the two people as a pair
            return &people[i];
        }
    }

    // No compatible pair found
    return NULL;
}

int main() {
    // Create an array of people
    Person people[] = {
        { 8, 7, 9 },
        { 9, 8, 7 },
        { 7, 9, 8 },
        { 6, 8, 9 },
        { 5, 7, 10 }
    };
    int n = sizeof(people) / sizeof(Person);

    // Find the most compatible pair of people
    Person *pair = findCompatiblePair(people, n);

    // Print the pair
    if (pair != NULL) {
        printf("The most compatible pair is: (%d, %d, %d)\n", pair->passion, pair->intelligence, pair->beauty);
    } else {
        printf("No compatible pair found\n");
    }

    return 0;
}