//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: active
#include <stdio.h>
#include <stdlib.h>

// A crane can lift a maximum of 100 units of weight.
#define MAX_WEIGHT 100

// A container can hold a maximum of 50 units of weight.
#define MAX_CONTAINER_WEIGHT 50

// A truck can hold a maximum of 200 units of weight.
#define MAX_TRUCK_WEIGHT 200

// A list of containers and their weights.
typedef struct container {
    int weight;
} container_t;

// A list of trucks and their capacities.
typedef struct truck {
    int capacity;
} truck_t;

// A function to compare two containers by weight.
int compare_containers(const void *a, const void *b) {
    const container_t *container_a = (const container_t *)a;
    const container_t *container_b = (const container_t *)b;

    return container_a->weight - container_b->weight;
}

// A function to compare two trucks by capacity.
int compare_trucks(const void *a, const void *b) {
    const truck_t *truck_a = (const truck_t *)a;
    const truck_t *truck_b = (const truck_t *)b;

    return truck_a->capacity - truck_b->capacity;
}

// A function to load containers onto trucks.
void load_containers(container_t *containers, int num_containers, truck_t *trucks, int num_trucks) {
    // Sort the containers by weight in ascending order.
    qsort(containers, num_containers, sizeof(container_t), compare_containers);

    // Sort the trucks by capacity in descending order.
    qsort(trucks, num_trucks, sizeof(truck_t), compare_trucks);

    // Initialize the current weight of each truck to 0.
    int truck_weights[num_trucks];
    for (int i = 0; i < num_trucks; i++) {
        truck_weights[i] = 0;
    }

    // Load each container onto the first truck that can hold it.
    for (int i = 0; i < num_containers; i++) {
        for (int j = 0; j < num_trucks; j++) {
            if (truck_weights[j] + containers[i].weight <= MAX_TRUCK_WEIGHT) {
                truck_weights[j] += containers[i].weight;
                break;
            }
        }
    }

    // Print the weight of each truck.
    for (int i = 0; i < num_trucks; i++) {
        printf("Truck %d: %d units\n", i + 1, truck_weights[i]);
    }
}

int main() {
    // Create a list of containers and their weights.
    container_t containers[] = {
        {10},
        {20},
        {30},
        {40},
        {50},
    };
    const int num_containers = sizeof(containers) / sizeof(container_t);

    // Create a list of trucks and their capacities.
    truck_t trucks[] = {
        {100},
        {150},
        {200},
    };
    const int num_trucks = sizeof(trucks) / sizeof(truck_t);

    // Load the containers onto the trucks.
    load_containers(containers, num_containers, trucks, num_trucks);

    return 0;
}