//Falcon-180B DATASET v1.0 Category: Task Scheduler ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Task structure
typedef struct task {
    char name[20];
    int priority;
    int burst_time;
    int waiting_time;
    int turnaround_time;
} Task;

// Function to compare tasks based on priority
int compare(const void *a, const void *b) {
    Task task1 = *((Task *)a);
    Task task2 = *((Task *)b);

    if (task1.priority > task2.priority)
        return 1;
    else if (task1.priority < task2.priority)
        return -1;
    else
        return 0;
}

// Function to execute a task
void execute_task(Task task) {
    printf("Executing task: %s\n", task.name);
    sleep(task.burst_time);
}

// Function to schedule tasks using Round Robin scheduling algorithm
void schedule_tasks(Task tasks[], int n) {
    int i, j, quantum = 2; // Time quantum = 2
    int completed_tasks = 0;
    int current_time = 0;

    // Sort tasks based on priority
    qsort(tasks, n, sizeof(Task), compare);

    // Execute each task
    for (i = 0; i < n; i++) {
        current_time += tasks[i].burst_time;
        completed_tasks++;

        // Print Gantt chart
        printf("\nGantt Chart at time %d:\n", current_time);
        for (j = 0; j < n; j++) {
            if (tasks[j].burst_time <= current_time)
                printf("Task %d completed\n", j + 1);
            else
                printf("Task %d waiting\n", j + 1);
        }

        if (completed_tasks == n)
            break;

        // Preemptive scheduling
        if (tasks[i].burst_time > quantum) {
            tasks[i].burst_time -= quantum;
            current_time += quantum;
        } else {
            tasks[i].burst_time = 0;
        }
    }
}

int main() {
    Task tasks[5] = {{"Task 1", 1, 5, 0, 0},
                     {"Task 2", 2, 3, 0, 0},
                     {"Task 3", 3, 8, 0, 0},
                     {"Task 4", 1, 6, 0, 0},
                     {"Task 5", 2, 6, 0, 0}};

    int n = sizeof(tasks) / sizeof(tasks[0]);

    schedule_tasks(tasks, n);

    return 0;
}