//Falcon-180B DATASET v1.0 Category: Internet Speed Test Application ; Style: configurable
// Speed Test Application using C

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <pthread.h>

#define MAX_THREADS 10
#define BUFFER_SIZE 1024
#define SERVER_PORT 8080
#define SERVER_IP "speedtest.example.com"

typedef struct {
    char ip[16];
    int port;
    int thread_id;
} server_info;

void *thread_func(void *arg) {
    server_info *server = (server_info *) arg;
    int sock = socket(AF_INET, SOCK_STREAM, 0);

    if (sock == -1) {
        printf("Error creating socket\n");
        return NULL;
    }

    struct sockaddr_in serv_addr;
    memset(&serv_addr, 0, sizeof(serv_addr));

    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(server->port);
    inet_pton(AF_INET, server->ip, &serv_addr.sin_addr);

    if (connect(sock, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
        printf("Error connecting to server\n");
        close(sock);
        return NULL;
    }

    char send_buffer[BUFFER_SIZE];
    memset(send_buffer, 'a', BUFFER_SIZE);

    int bytes_sent = send(sock, send_buffer, BUFFER_SIZE, 0);

    if (bytes_sent < 0) {
        printf("Error sending data\n");
        close(sock);
        return NULL;
    }

    close(sock);

    return NULL;
}

int main() {
    int num_servers = 3;
    server_info servers[num_servers];

    strcpy(servers[0].ip, "192.168.1.1");
    servers[0].port = 8080;
    servers[0].thread_id = 1;

    strcpy(servers[1].ip, "192.168.1.2");
    servers[1].port = 8080;
    servers[1].thread_id = 2;

    strcpy(servers[2].ip, "192.168.1.3");
    servers[2].port = 8080;
    servers[2].thread_id = 3;

    pthread_t threads[num_servers];

    for (int i = 0; i < num_servers; i++) {
        pthread_create(&threads[i], NULL, thread_func, (void *) &servers[i]);
    }

    for (int i = 0; i < num_servers; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}