//GEMINI-pro DATASET v1.0 Category: RAM usage monitor ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/sysinfo.h>

// Custom data structure to store RAM usage information
typedef struct ram_usage {
    unsigned long total_ram;
    unsigned long free_ram;
    unsigned long used_ram;
    unsigned long buff_cache_ram;
    unsigned long swap_total;
    unsigned long swap_free;
    unsigned long swap_used;
} ram_usage;

// Function to get RAM usage information
ram_usage get_ram_usage() {
    struct sysinfo sys_info;
    ram_usage ram_usage;

    // Get system information
    if (sysinfo(&sys_info) != 0) {
        perror("sysinfo failed");
        exit(EXIT_FAILURE);
    }

    // Store RAM usage information in the data structure
    ram_usage.total_ram = sys_info.totalram;
    ram_usage.free_ram = sys_info.freeram;
    ram_usage.used_ram = sys_info.totalram - sys_info.freeram;
    ram_usage.buff_cache_ram = sys_info.bufferram;
    ram_usage.swap_total = sys_info.totalswap;
    ram_usage.swap_free = sys_info.freeswap;
    ram_usage.swap_used = sys_info.totalswap - sys_info.freeswap;

    return ram_usage;
}

// Function to print RAM usage information
void print_ram_usage(ram_usage ram_usage) {
    printf("Total RAM: %lu MB\n", ram_usage.total_ram / 1024 / 1024);
    printf("Free RAM: %lu MB\n", ram_usage.free_ram / 1024 / 1024);
    printf("Used RAM: %lu MB\n", ram_usage.used_ram / 1024 / 1024);
    printf("Buff/Cache RAM: %lu MB\n", ram_usage.buff_cache_ram / 1024 / 1024);
    printf("Total Swap: %lu MB\n", ram_usage.swap_total / 1024 / 1024);
    printf("Free Swap: %lu MB\n", ram_usage.swap_free / 1024 / 1024);
    printf("Used Swap: %lu MB\n", ram_usage.swap_used / 1024 / 1024);
}

// Main function
int main() {
    // Get RAM usage information
    ram_usage ram_usage = get_ram_usage();

    // Print RAM usage information
    print_ram_usage(ram_usage);

    return 0;
}