//LLAMA2-13B DATASET v1.0 Category: Socket programming ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
  int sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("socket failed");
    exit(EXIT_FAILURE);
  }

  struct sockaddr_in server_addr = {
    .sin_family = AF_INET,
    .sin_port = htons(PORT),
    .sin_addr.s_addr = INADDR_ANY
  };

  if (bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("bind failed");
    exit(EXIT_FAILURE);
  }

  if (listen(sock, 3) < 0) {
    perror("listen failed");
    exit(EXIT_FAILURE);
  }

  printf("Listening on port %d...\n", PORT);

  socklen_t client_len = sizeof(struct sockaddr_in);
  int client_sock = accept(sock, (struct sockaddr *)&server_addr, &client_len);
  if (client_sock < 0) {
    perror("accept failed");
    exit(EXIT_FAILURE);
  }

  char buffer[1024];
  int bytes_read = read(client_sock, buffer, 1024);
  if (bytes_read < 0) {
    perror("read failed");
    exit(EXIT_FAILURE);
  }

  printf("Received message: %s\n", buffer);

  char *message = "Hello, client!";
  send(client_sock, message, strlen(message), 0);

  close(client_sock);
  close(sock);

  return 0;
}