//GEMINI-pro DATASET v1.0 Category: System administration ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/resource.h>

int main() {
  // Get the current user's name.
  char *username = getlogin();

  // Get the current working directory.
  char cwd[1024];
  getcwd(cwd, sizeof(cwd));

  // Print the current user's name and working directory.
  printf("Current user: %s\n", username);
  printf("Current working directory: %s\n", cwd);

  // Create a new child process.
  pid_t child_pid = fork();

  if (child_pid == 0) {
    // This is the child process.

    // Change the current working directory to the user's home directory.
    chdir("/home/user");

    // Execute the 'ls' command.
    execlp("ls", "ls", "-l", NULL);

    // If the 'ls' command fails, print an error message and exit.
    perror("execlp");
    exit(1);
  } else {
    // This is the parent process.

    // Wait for the child process to finish.
    int status;
    waitpid(child_pid, &status, 0);

    // Print the exit status of the child process.
    printf("Child process exited with status %d\n", status);

    // Get the resource usage of the child process.
    struct rusage usage;
    getrusage(RUSAGE_CHILDREN, &usage);

    // Print the resource usage of the child process.
    printf("Child process resource usage:\n");
    printf("  User time: %ld.%06ld seconds\n", usage.ru_utime.tv_sec, usage.ru_utime.tv_usec);
    printf("  System time: %ld.%06ld seconds\n", usage.ru_stime.tv_sec, usage.ru_stime.tv_usec);
  }

  return 0;
}