//GEMINI-pro DATASET v1.0 Category: Alien Invasion Probability Calculator ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the number of possible outcomes for each event
#define NUM_OUTCOMES_PLANET_TYPE 3
#define NUM_OUTCOMES_STAR_TYPE 4
#define NUM_OUTCOMES_DISTANCE 5

// Define the probabilities for each event
double probs_planet_type[NUM_OUTCOMES_PLANET_TYPE] = {0.5, 0.3, 0.2};
double probs_star_type[NUM_OUTCOMES_STAR_TYPE] = {0.7, 0.2, 0.1, 0.05};
double probs_distance[NUM_OUTCOMES_DISTANCE] = {0.2, 0.3, 0.25, 0.15, 0.1};

// Calculate the probability of an alien invasion
double calculate_invasion_probability() {
  // Calculate the probability of each event
  double prob_planet_type = 0.0;
  for (int i = 0; i < NUM_OUTCOMES_PLANET_TYPE; i++) {
    prob_planet_type += probs_planet_type[i];
  }

  double prob_star_type = 0.0;
  for (int i = 0; i < NUM_OUTCOMES_STAR_TYPE; i++) {
    prob_star_type += probs_star_type[i];
  }

  double prob_distance = 0.0;
  for (int i = 0; i < NUM_OUTCOMES_DISTANCE; i++) {
    prob_distance += probs_distance[i];
  }

  // Calculate the probability of an alien invasion
  double prob_invasion = prob_planet_type * prob_star_type * prob_distance;
  return prob_invasion;
}

// Print the invasion probability
void print_invasion_probability(double prob_invasion) {
  printf("The probability of an alien invasion is: %f\n", prob_invasion);
}

// Main function
int main() {
  // Calculate the invasion probability
  double prob_invasion = calculate_invasion_probability();

  // Print the invasion probability
  print_invasion_probability(prob_invasion);

  return 0;
}