//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>

#define N 5 // Define size of the maze
#define TRUE 1
#define FALSE 0

int maze[N][N] = {
    {1, 0, 1, 1, 1},
    {1, 0, 1, 0, 1},
    {1, 1, 1, 0, 1},
    {0, 0, 0, 0, 1},
    {1, 1, 1, 1, 1}
};

int path[N][N] = {0}; // Stores the solution path

// Function to print the maze and the path found
void printMazeAndPath() {
    printf("Maze:\n");
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            if (maze[i][j] == 1) {
                printf(" ## "); // Wall
            } else {
                if (path[i][j])
                    printf(" .. "); // Path
                else
                    printf("    "); // Empty space
            }
        }
        printf("\n");
    }
}

// Function to check if a move is valid
int isSafe(int x, int y) {
    return (x >= 0 && x < N && y >= 0 && y < N && maze[x][y] == 0);
}

// Recursive function to find the path using DFS
int findPath(int x, int y) {
    // If we reach the bottom-right corner, return true
    if (x == N - 1 && y == N - 1) {
        path[x][y] = 1;
        return TRUE;
    }

    // Check if the move is safe
    if (isSafe(x, y)) {
        // Mark cell as part of the path
        path[x][y] = 1;

        // Move down
        if (findPath(x + 1, y))
            return TRUE;

        // Move right
        if (findPath(x, y + 1))
            return TRUE;

        // Move up
        if (findPath(x - 1, y))
            return TRUE;

        // Move left
        if (findPath(x, y - 1))
            return TRUE;

        // Backtrack
        path[x][y] = 0; 
    }
    return FALSE;
}

int main() {
    printf("Finding path in the following Maze:\n");
    printMazeAndPath();

    if (findPath(0, 0)) {
        printf("\nPath found:\n");
        printMazeAndPath();
    } else {
        printf("No path exists in the maze.\n");
    }
    
    return 0;
}