//Falcon-180B DATASET v1.0 Category: Tower of Hanoi Problem ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#define NUM_DISKS 4

// Define structure for thread data
struct thread_data {
    int from_rod;
    int to_rod;
    int aux_rod;
};

// Function for the thread to execute
void *move_disk(void *arg) {
    struct thread_data *data = (struct thread_data *) arg;

    // Print the move being made
    printf("Move disk %d from rod %d to rod %d using rod %d\n",
           NUM_DISKS - 1, data->from_rod, data->to_rod, data->aux_rod);

    // Wait for 1 second
    sleep(1);

    // Move the disk
    int disk = NUM_DISKS - 1;
    while (disk > 0) {
        printf("Move disk %d from rod %d to rod %d\n", disk, data->from_rod, data->to_rod);
        disk--;
        sleep(1);
    }

    // Notify main thread that the move is complete
    pthread_exit(0);
}

int main() {
    pthread_t threads[NUM_DISKS];

    // Initialize the rods with the disks
    int rods[NUM_DISKS] = {0, 1, 2};

    // Print the initial state of the rods
    printf("Initial state:\n");
    for (int i = 0; i < NUM_DISKS; i++) {
        printf("Disk %d is on rod %d\n", i+1, rods[i]);
    }

    // Move the disks from the initial rod to the final rod
    for (int i = NUM_DISKS - 1; i >= 0; i--) {
        struct thread_data data;
        data.from_rod = 0;
        data.to_rod = 2;
        data.aux_rod = 1;

        // Create a thread for each disk move
        pthread_create(&threads[i], NULL, move_disk, &data);

        // Wait for the thread to complete before moving the next disk
        pthread_join(threads[i], NULL);
    }

    // Print the final state of the rods
    printf("\nFinal state:\n");
    for (int i = 0; i < NUM_DISKS; i++) {
        printf("Disk %d is on rod %d\n", i+1, rods[i]);
    }

    return 0;
}