//Code Llama-13B DATASET v1.0 Category: Client Server Application ; Style: inquisitive
/*
 * C Client Server Application Example Program
 *
 * This program demonstrates a basic client-server application using sockets
 * in C. The client sends a request to the server, which responds with
 * a message.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 8080
#define MAX_BUF 1024

int main() {
    // Create socket for client
    int client_sock = socket(AF_INET, SOCK_STREAM, 0);
    if (client_sock < 0) {
        perror("socket");
        return 1;
    }

    // Set up address struct for server
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);

    // Connect to server
    if (connect(client_sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect");
        return 1;
    }

    // Send request to server
    char request[] = "Hello, server!";
    if (send(client_sock, request, strlen(request), 0) < 0) {
        perror("send");
        return 1;
    }

    // Receive response from server
    char buffer[MAX_BUF];
    if (recv(client_sock, buffer, MAX_BUF, 0) < 0) {
        perror("recv");
        return 1;
    }

    // Print response from server
    printf("Response from server: %s\n", buffer);

    // Close socket
    close(client_sock);

    return 0;
}