//Falcon2-11B DATASET v1.0 Category: Interprocess communication ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

void print_error(const char *msg) {
    perror(msg);
    exit(1);
}

int main() {
    // Create a socket
    int sockfd;
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        print_error("socket failed");
    }

    // Set up the address struct
    struct sockaddr_in server_addr;
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");
    server_addr.sin_port = htons(1234);

    // Connect to the server
    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        print_error("connect failed");
    }

    // Send a message to the server
    char message[] = "Hello, server!";
    send(sockfd, message, strlen(message), 0);

    // Receive a response from the server
    char response[1024];
    if (recv(sockfd, response, sizeof(response), 0) <= 0) {
        print_error("recv failed");
    }

    // Print the response
    printf("Received response: %s\n", response);

    // Close the socket
    close(sockfd);

    return 0;
}