//Falcon-180B DATASET v1.0 Category: Email Client ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_EMAILS 1000
#define MAX_EMAIL_LENGTH 1000
#define MAX_EMAIL_SUBJECT_LENGTH 100
#define MAX_EMAIL_BODY_LENGTH 1000

typedef struct {
    char from[MAX_EMAIL_LENGTH];
    char subject[MAX_EMAIL_SUBJECT_LENGTH];
    char body[MAX_EMAIL_BODY_LENGTH];
} Email;

Email emails[MAX_EMAILS];
int num_emails = 0;

void add_email(char* from, char* subject, char* body) {
    if (num_emails >= MAX_EMAILS) {
        printf("Error: Too many emails.\n");
        return;
    }

    strcpy(emails[num_emails].from, from);
    strcpy(emails[num_emails].subject, subject);
    strcpy(emails[num_emails].body, body);

    num_emails++;
}

void print_emails() {
    printf("Subject\tFrom\tBody\n");
    for (int i = 0; i < num_emails; i++) {
        printf("%s\t%s\t%s\n", emails[i].subject, emails[i].from, emails[i].body);
    }
}

void delete_email(int index) {
    if (index >= num_emails || index < 0) {
        printf("Error: Invalid email index.\n");
        return;
    }

    num_emails--;
    for (int i = index; i < num_emails; i++) {
        emails[i] = emails[i + 1];
    }
}

int main() {
    add_email("john@example.com", "Hello", "How are you?");
    add_email("jane@example.com", "Re: Hello", "I'm doing well, thanks!");
    print_emails();
    delete_email(1);
    print_emails();

    return 0;
}