//Falcon-180B DATASET v1.0 Category: Memory management ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define a struct to hold data
typedef struct {
    int id;
    char name[50];
} Person;

// Function to create a new person
Person* create_person(int id, char* name) {
    Person* new_person = (Person*)malloc(sizeof(Person));
    if (new_person == NULL) {
        printf("Error: Memory allocation failed.\n");
        return NULL;
    }

    new_person->id = id;
    strcpy(new_person->name, name);

    return new_person;
}

// Function to delete a person
void delete_person(Person* person) {
    free(person);
}

// Function to print a person's information
void print_person(Person* person) {
    printf("ID: %d\nName: %s\n", person->id, person->name);
}

int main() {
    // Create a new person
    Person* new_person = create_person(1, "John Doe");
    if (new_person == NULL) {
        return 1;
    }

    // Print the person's information
    print_person(new_person);

    // Delete the person
    delete_person(new_person);

    // Print a message to confirm deletion
    printf("Person deleted.\n");

    return 0;
}