//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: brave
#include <stdio.h>

#define SIZE 8

void print_binary(unsigned char num) {
    for (int i = 7; i >= 0; i--) {
        printf("%d", (num >> i) & 1);
    }
}

int main() {
    unsigned char num1 = 0b11001100;
    unsigned char num2 = 0b00110011;

    printf("Binary representation of num1: ");
    print_binary(num1);
    printf("\n");

    printf("Binary representation of num2: ");
    print_binary(num2);
    printf("\n");

    // Bitwise OR operation
    unsigned char result_or = num1 | num2;
    printf("Result of bitwise OR operation: ");
    print_binary(result_or);
    printf("\n");

    // Bitwise AND operation
    unsigned char result_and = num1 & num2;
    printf("Result of bitwise AND operation: ");
    print_binary(result_and);
    printf("\n");

    // Bitwise XOR operation
    unsigned char result_xor = num1 ^ num2;
    printf("Result of bitwise XOR operation: ");
    print_binary(result_xor);
    printf("\n");

    // Bitwise NOT operation
    unsigned char result_not = ~num1;
    printf("Result of bitwise NOT operation: ");
    print_binary(result_not);
    printf("\n");

    // Bitwise left shift operation
    unsigned char result_left_shift = num1 << 2;
    printf("Result of bitwise left shift operation: ");
    print_binary(result_left_shift);
    printf("\n");

    // Bitwise right shift operation
    unsigned char result_right_shift = num1 >> 2;
    printf("Result of bitwise right shift operation: ");
    print_binary(result_right_shift);
    printf("\n");

    return 0;
}