//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: Claude Shannon
// Define the basic geometric shapes and their properties.

typedef struct {
    double x;
    double y;
} Point;

typedef struct {
    Point a;
    Point b;
} LineSegment;

typedef struct {
    Point a;
    Point b;
    Point c;
} Triangle;

// Define the fundamental geometric operations.

double distance(Point a, Point b) {
    return sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}

double slope(LineSegment ls) {
    return (ls.b.y - ls.a.y) / (ls.b.x - ls.a.x);
}

double area(Triangle t) {
    return 0.5 * abs((t.a.x * (t.b.y - t.c.y) + t.b.x * (t.c.y - t.a.y) + t.c.x * (t.a.y - t.b.y)));
}

// Define some helper functions.

int is_collinear(LineSegment ls1, LineSegment ls2) {
    return abs(slope(ls1) - slope(ls2)) < 1e-6;
}

int is_intersecting(LineSegment ls1, LineSegment ls2) {
    double s1 = (ls2.b.x - ls2.a.x) * (ls1.a.y - ls2.a.y) - (ls2.b.y - ls2.a.y) * (ls1.a.x - ls2.a.x);
    double s2 = (ls2.b.x - ls2.a.x) * (ls1.b.y - ls2.a.y) - (ls2.b.y - ls2.a.y) * (ls1.b.x - ls2.a.x);
    return (s1 * s2 < 0) && (is_collinear(ls1, ls2) == 0);
}

// Define the main function.

int main() {
    // Create some geometric shapes.

    Point a = {0, 0};
    Point b = {1, 1};
    LineSegment ls1 = {a, b};
    Point c = {2, 2};
    Triangle t = {a, b, c};

    // Perform some geometric operations.

    double d = distance(a, b);
    double s = slope(ls1);
    double A = area(t);

    // Print the results.

    printf("The distance between points a and b is %f.\n", d);
    printf("The slope of line segment ls1 is %f.\n", s);
    printf("The area of triangle t is %f.\n", A);

    return 0;
}