//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct Point {
    double x;
    double y;
} Point;

typedef struct Line {
    Point p1;
    Point p2;
} Line;

typedef struct Circle {
    Point center;
    double radius;
} Circle;

// Function to calculate the distance between two points
double distance(Point p1, Point p2) {
    return sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y));
}

// Function to check if a point is on a line
int is_on_line(Point p, Line l) {
    return fabs((l.p2.x - l.p1.x) * (p.y - l.p1.y) - (l.p2.y - l.p1.y) * (p.x - l.p1.x)) < 1e-9;
}

// Function to check if a point is inside a circle
int is_inside_circle(Point p, Circle c) {
    return distance(p, c.center) < c.radius;
}

// Function to check if two lines intersect
int do_lines_intersect(Line l1, Line l2) {
    double x1 = l1.p1.x, y1 = l1.p1.y, x2 = l1.p2.x, y2 = l1.p2.y, x3 = l2.p1.x, y3 = l2.p1.y, x4 = l2.p2.x, y4 = l2.p2.y;
    return (x1 * y2 - x2 * y1) * (x3 * y4 - x4 * y3) - (x1 * y3 - x3 * y1) * (x2 * y4 - x4 * y2) > 0 && (x1 * y2 - x2 * y1) * (x4 * y3 - x3 * y4) - (x1 * y4 - x4 * y1) * (x2 * y3 - x3 * y2) > 0;
}

// Function to find the intersection point of two lines
Point intersection_point(Line l1, Line l2) {
    double x1 = l1.p1.x, y1 = l1.p1.y, x2 = l1.p2.x, y2 = l1.p2.y, x3 = l2.p1.x, y3 = l2.p1.y, x4 = l2.p2.x, y4 = l2.p2.y;
    double t = ((x1 * y2 - x2 * y1) * (x3 * y4 - x4 * y3) - (x1 * y3 - x3 * y1) * (x2 * y4 - x4 * y2)) / ((x1 * y2 - x2 * y1) * (x4 - x3) - (x1 - x2) * (x2 * y4 - x4 * y2));
    double u = ((x1 * y2 - x2 * y1) * (x4 * y3 - x3 * y4) - (x1 * y3 - x3 * y1) * (x4 * y2 - x2 * y4)) / ((x3 * y4 - x4 * y3) * (x2 - x1) - (x3 - x4) * (x2 * y1 - x1 * y2));
    return (Point){x1 + t * (x2 - x1), y1 + t * (y2 - y1)};
}

// Function to test the geometric algorithms
int main() {
    Point p1 = {0, 0}, p2 = {1, 1}, p3 = {2, 2}, p4 = {0, 2};
    Line l1 = {p1, p2}, l2 = {p3, p4};
    Circle c = {{1, 1}, 1};

    printf("Distance between p1 and p2: %.2f\n", distance(p1, p2));
    printf("Is p3 on l1? %s\n", is_on_line(p3, l1) ? "Yes" : "No");
    printf("Is p4 inside c? %s\n", is_inside_circle(p4, c) ? "Yes" : "No");
    printf("Do l1 and l2 intersect? %s\n", do_lines_intersect(l1, l2) ? "Yes" : "No");
    printf("Intersection point of l1 and l2: (%.2f, %.2f)\n", intersection_point(l1, l2).x, intersection_point(l1, l2).y);

    return 0;
}