//Falcon2-11B DATASET v1.0 Category: Database querying ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

// Function to query the database and return the most popular movie genre
const char* getMostPopularGenre(sqlite3* db) {
    char* query = "SELECT genre, COUNT(*) AS count FROM movies GROUP BY genre ORDER BY count DESC LIMIT 1";
    sqlite3_stmt* stmt;
    const char* errmsg;
    char* genre;

    if (sqlite3_prepare_v2(db, query, strlen(query), &stmt, &errmsg)!= SQLITE_OK) {
        fprintf(stderr, "Prepare statement error: %s\n", errmsg);
        return NULL;
    }

    if (sqlite3_step(stmt)!= SQLITE_ROW) {
        fprintf(stderr, "Step statement error\n");
        return NULL;
    }

    genre = (char*)sqlite3_column_text(stmt, 0);
    sqlite3_finalize(stmt);

    return genre;
}

int main() {
    sqlite3* db;
    char* errmsg;
    int rc;

    // Open the database
    rc = sqlite3_open("movies.db", &db);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    // Insert movies into the database
    rc = sqlite3_exec(db, "CREATE TABLE movies (id INTEGER PRIMARY KEY, title TEXT, genre TEXT)", NULL, NULL, &errmsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "Create table error: %s\n", errmsg);
        return 1;
    }

    rc = sqlite3_exec(db, "INSERT INTO movies VALUES (1, 'The Shawshank Redemption', 'Drama')", NULL, NULL, &errmsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "Insert error: %s\n", errmsg);
        return 1;
    }

    rc = sqlite3_exec(db, "INSERT INTO movies VALUES (2, 'The Godfather', 'Crime')", NULL, NULL, &errmsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "Insert error: %s\n", errmsg);
        return 1;
    }

    rc = sqlite3_exec(db, "INSERT INTO movies VALUES (3, 'Pulp Fiction', 'Crime')", NULL, NULL, &errmsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "Insert error: %s\n", errmsg);
        return 1;
    }

    rc = sqlite3_exec(db, "INSERT INTO movies VALUES (4, 'The Dark Knight', 'Action')", NULL, NULL, &errmsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "Insert error: %s\n", errmsg);
        return 1;
    }

    rc = sqlite3_exec(db, "INSERT INTO movies VALUES (5, 'Forrest Gump', 'Drama')", NULL, NULL, &errmsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "Insert error: %s\n", errmsg);
        return 1;
    }

    const char* genre = getMostPopularGenre(db);
    if (genre == NULL) {
        fprintf(stderr, "Error getting most popular genre\n");
        return 1;
    }

    printf("Most popular genre: %s\n", genre);

    // Close the database
    sqlite3_close(db);

    return 0;
}