//GEMINI-pro DATASET v1.0 Category: Warehouse Management System ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Romeo and Juliet Warehouse Management System

typedef struct {
  char name[50];
  int quantity;
  float price;
} product;

product inventory[100];
int numProducts = 0;

void addProduct(char *name, int quantity, float price) {
  strcpy(inventory[numProducts].name, name);
  inventory[numProducts].quantity = quantity;
  inventory[numProducts].price = price;
  numProducts++;
}

void printInventory() {
  for (int i = 0; i < numProducts; i++) {
    printf("%s: %d units at $%.2f each\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
  }
}

void findProduct(char *name) {
  for (int i = 0; i < numProducts; i++) {
    if (strcmp(inventory[i].name, name) == 0) {
      printf("%s: %d units at $%.2f each\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
      return;
    }
  }
  printf("Product not found.\n");
}

void removeProduct(char *name) {
  for (int i = 0; i < numProducts; i++) {
    if (strcmp(inventory[i].name, name) == 0) {
      for (int j = i + 1; j < numProducts; j++) {
        inventory[j - 1] = inventory[j];
      }
      numProducts--;
      return;
    }
  }
  printf("Product not found.\n");
}

void updateProduct(char *name, int quantity, float price) {
  for (int i = 0; i < numProducts; i++) {
    if (strcmp(inventory[i].name, name) == 0) {
      inventory[i].quantity = quantity;
      inventory[i].price = price;
      return;
    }
  }
  printf("Product not found.\n");
}

int main() {
  // Add some products to the inventory
  addProduct("Romeo", 10, 10.0);
  addProduct("Juliet", 20, 12.0);
  addProduct("Tybalt", 5, 15.0);
  addProduct("Mercutio", 3, 18.0);
  addProduct("Benvolio", 2, 20.0);

  // Print the inventory
  printf("Inventory:\n");
  printInventory();

  // Find a product
  printf("\nFind product Romeo:\n");
  findProduct("Romeo");

  // Remove a product
  printf("\nRemove product Tybalt:\n");
  removeProduct("Tybalt");

  // Update a product
  printf("\nUpdate product Juliet to 30 units and $13.00 each:\n");
  updateProduct("Juliet", 30, 13.0);

  // Print the updated inventory
  printf("\nUpdated inventory:\n");
  printInventory();

  return 0;
}