//Falcon-180B DATASET v1.0 Category: Mailing list manager ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define a structure for the mailing list
typedef struct {
    char name[50];
    char email[100];
} mailing_list;

// Function to add a new member to the mailing list
void add_member(mailing_list* list, int size, char* name, char* email) {
    // Check if the mailing list is full
    if (size == 0) {
        printf("Mailing list is full.\n");
        return;
    }

    // Add the new member to the mailing list
    strcpy(list[size].name, name);
    strcpy(list[size].email, email);
    size++;
}

// Function to remove a member from the mailing list
void remove_member(mailing_list* list, int size, char* email) {
    // Find the index of the member to remove
    int i;
    for (i = 0; i < size; i++) {
        if (strcmp(list[i].email, email) == 0) {
            break;
        }
    }

    // Remove the member from the mailing list
    if (i == size) {
        printf("Member not found.\n");
    } else {
        size--;
        while (i < size) {
            strcpy(list[i].name, list[i+1].name);
            strcpy(list[i].email, list[i+1].email);
            i++;
        }
    }
}

// Function to send an email to all members of the mailing list
void send_email(mailing_list* list, int size, char* subject, char* message) {
    // Loop through the mailing list and send an email to each member
    printf("Sending email to %d members:\n", size);
    for (int i = 0; i < size; i++) {
        printf("Sending email to %s (%s)\n", list[i].name, list[i].email);
    }
}

int main() {
    // Initialize the mailing list
    mailing_list list[100];
    int size = 0;

    // Add some members to the mailing list
    add_member(list, size, "John Doe", "johndoe@example.com");
    add_member(list, size, "Jane Doe", "janedoe@example.com");
    add_member(list, size, "Bob Smith", "bobsmith@example.com");

    // Remove a member from the mailing list
    remove_member(list, size, "janedoe@example.com");

    // Send an email to all members of the mailing list
    send_email(list, size, "Test Email", "This is a test email sent to all members of the mailing list.");

    return 0;
}