//Falcon-180B DATASET v1.0 Category: Phone Book ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_CONTACTS 100
#define MAX_NAME_SIZE 50
#define MAX_NUMBER_SIZE 20

typedef struct {
    char name[MAX_NAME_SIZE];
    char number[MAX_NUMBER_SIZE];
} Contact;

void add_contact(Contact* contacts, int num_contacts, char* name, char* number) {
    for (int i = 0; i < num_contacts; i++) {
        if (strcmp(contacts[i].name, name) == 0) {
            strcpy(contacts[i].number, number);
            return;
        }
    }
    strcpy(contacts[num_contacts].name, name);
    strcpy(contacts[num_contacts].number, number);
    num_contacts++;
}

void delete_contact(Contact* contacts, int num_contacts, char* name) {
    for (int i = 0; i < num_contacts; i++) {
        if (strcmp(contacts[i].name, name) == 0) {
            for (int j = i; j < num_contacts - 1; j++) {
                strcpy(contacts[j].name, contacts[j + 1].name);
                strcpy(contacts[j].number, contacts[j + 1].number);
            }
            num_contacts--;
            return;
        }
    }
}

void search_contact(Contact* contacts, int num_contacts, char* name) {
    for (int i = 0; i < num_contacts; i++) {
        if (strcmp(contacts[i].name, name) == 0) {
            printf("Name: %s\nNumber: %s\n", contacts[i].name, contacts[i].number);
            return;
        }
    }
    printf("Contact not found.\n");
}

int main() {
    Contact contacts[MAX_CONTACTS];
    int num_contacts = 0;

    add_contact(contacts, num_contacts, "John Doe", "123-456-7890");
    add_contact(contacts, num_contacts, "Jane Doe", "987-654-3210");

    search_contact(contacts, num_contacts, "John Doe");
    search_contact(contacts, num_contacts, "Jane Doe");

    delete_contact(contacts, num_contacts, "John Doe");
    search_contact(contacts, num_contacts, "John Doe");

    return 0;
}