//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: mind-bending
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_PKT_SIZE 65535
#define SNAPLEN 1514
#define PCAP_FILE "dump.pcap"

typedef struct {
    u_char *data;
    size_t len;
} Packet;

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Packet received with length %d\n", header->len);
}

void capture_loop(pcap_t *handle) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_loop(handle, 0, process_packet, NULL);
}

int main(int argc, char *argv[]) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    char *dev = "eth0";
    handle = pcap_open_live(dev, SNAPLEN, 1, 1000, errbuf);

    if (handle == NULL) {
        fprintf(stderr, "Error opening device %s: %s\n", dev, errbuf);
        exit(1);
    }

    if (pcap_setfilter(handle, "tcp")!= 0) {
        fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    if (pcap_dump_open(handle, PCAP_FILE)!= 0) {
        fprintf(stderr, "Error opening dump file: %s\n", pcap_geterr(handle));
        exit(1);
    }

    capture_loop(handle);

    pcap_dump_close(handle);
    pcap_close(handle);
    return 0;
}