//GEMINI-pro DATASET v1.0 Category: GPS Navigation Simulation ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
  double lat;
  double lon;
} point;

typedef struct {
  point start;
  point end;
  double distance;
} route;

point new_point(double lat, double lon) {
  point p;
  p.lat = lat;
  p.lon = lon;
  return p;
}

double distance(point p1, point p2) {
  double dlat = p2.lat - p1.lat;
  double dlon = p2.lon - p1.lon;
  return sqrt(dlat * dlat + dlon * dlon);
}

route new_route(point start, point end) {
  route r;
  r.start = start;
  r.end = end;
  r.distance = distance(start, end);
  return r;
}

void print_route(route r) {
  printf("Start: (%f, %f)\n", r.start.lat, r.start.lon);
  printf("End: (%f, %f)\n", r.end.lat, r.end.lon);
  printf("Distance: %f\n", r.distance);
}

int main() {
  point start = new_point(37.4419, 122.0840);
  point end = new_point(37.4224, 122.0800);
  route r = new_route(start, end);

  print_route(r);
  
  return 0;
}