//LLAMA2-13B DATASET v1.0 Category: Client Server Application ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 8080

// Structure to hold client and server information
struct client_server {
    int sock;
    struct sockaddr_in server_addr;
    char buffer[1024];
};

// Function to create a socket
int create_socket(int domain, int type, int protocol) {
    int sock = socket(domain, type, protocol);
    if (sock < 0) {
        perror("Error creating socket");
        exit(1);
    }
    return sock;
}

// Function to bind a socket to a port
void bind_socket(int sock, int port) {
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = INADDR_ANY;
    server_addr.sin_port = htons(port);

    if (bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("Error binding socket");
        exit(1);
    }
}

// Function to listen for incoming connections
void listen_socket(int sock) {
    if (listen(sock, 3) < 0) {
        perror("Error listening for incoming connections");
        exit(1);
    }
}

// Function to accept an incoming connection
int accept_connection(int sock) {
    struct sockaddr_in client_addr;
    socklen_t client_len = sizeof(client_addr);
    int client_sock = accept(sock, (struct sockaddr *)&client_addr, &client_len);

    if (client_sock < 0) {
        perror("Error accepting incoming connection");
        exit(1);
    }

    return client_sock;
}

// Function to send and receive data between the client and server
void send_receive(int sock) {
    char buffer[1024];
    int bytes_sent = send(sock, "Hello, client!", 13, 0);
    if (bytes_sent < 0) {
        perror("Error sending data");
        exit(1);
    }

    recv(sock, buffer, 1024, 0);
    printf("Server received: %s\n", buffer);
}

// Function to handle the client-server communication
void handle_client(int sock) {
    char command[1024];
    int bytes_read = recv(sock, command, 1024, 0);
    if (bytes_read < 0) {
        perror("Error receiving command");
        exit(1);
    }

    // If the command is "quit", exit the program
    if (strcmp(command, "quit") == 0) {
        printf("Client requested quit\n");
        exit(0);
    }

    // If the command is "hello", send a response back to the client
    if (strcmp(command, "hello") == 0) {
        char *response = "Hello, client!";
        send(sock, response, strlen(response), 0);
    }

    // If the command is anything else, send an error message back to the client
    else {
        char *response = "Invalid command";
        send(sock, response, strlen(response), 0);
    }
}

int main() {
    // Create a socket
    int sock = create_socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("Error creating socket");
        exit(1);
    }

    // Bind the socket to a port
    bind_socket(sock, PORT);

    // Listen for incoming connections
    listen_socket(sock);

    // Accept an incoming connection
    int client_sock = accept_connection(sock);

    // Handle the client-server communication
    handle_client(client_sock);

    // Close the socket
    close(client_sock);
    close(sock);

    return 0;
}