//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather types
#define SUNNY 0
#define CLOUDY 1
#define RAINING 2
#define SNOWING 3

// Define the probability of each weather type
#define SUNNY_PROB 0.3
#define CLOUDY_PROB 0.4
#define RAINING_PROB 0.2
#define SNOWING_PROB 0.1

// Function to generate a random weather type
int generate_weather() {
  // Get a random number between 0 and 99
  int random_number = rand() % 100;

  // Determine the weather type based on the random number
  if (random_number < SUNNY_PROB * 100) {
    return SUNNY;
  } else if (random_number < (SUNNY_PROB + CLOUDY_PROB) * 100) {
    return CLOUDY;
  } else if (random_number < (SUNNY_PROB + CLOUDY_PROB + RAINING_PROB) * 100) {
    return RAINING;
  } else {
    return SNOWING;
  }
}

// Function to print the weather type
void print_weather(int weather) {
  switch (weather) {
  case SUNNY:
    printf("The weather is sunny.\n");
    break;
  case CLOUDY:
    printf("The weather is cloudy.\n");
    break;
  case RAINING:
    printf("The weather is raining.\n");
    break;
  case SNOWING:
    printf("The weather is snowing.\n");
    break;
  }
}

// Main function
int main() {
  // Initialize the random number generator
  srand(time(NULL));

  // Generate a random weather type
  int weather = generate_weather();

  // Print the weather type
  print_weather(weather);

  return 0;
}