//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: mathematical
#include <stdlib.h>
#include <stdio.h>

#define NUM_LANE 3
#define NUM_CARS 10

// Define the traffic light status
enum TrafficLightStatus { RED, YELLOW, GREEN };

// Define the car movement direction
enum CarDirection { LEFT, RIGHT, STRAIGHT };

// Structure to represent a car
typedef struct Car {
    int position;
    enum CarDirection direction;
    enum TrafficLightStatus currentLight;
} Car;

// Function to simulate traffic flow
void simulateTrafficFlow(Car *cars) {
    // Calculate the next position of each car
    for (int i = 0; i < NUM_CARS; i++) {
        switch (cars[i].direction) {
            case LEFT:
                cars[i].position--;
                break;
            case RIGHT:
                cars[i].position++;
                break;
            case STRAIGHT:
                cars[i].position = 0;
                break;
        }

        // Check if the car has reached the traffic light
        if (cars[i].position == 0) {
            cars[i].currentLight = RED;
        } else if (cars[i].position == NUM_LANE - 1) {
            cars[i].currentLight = GREEN;
        } else {
            cars[i].currentLight = YELLOW;
        }
    }

    // Print the traffic light status
    for (int i = 0; i < NUM_CARS; i++) {
        printf("Car %d: Position %d, Direction %c, Light Status %c\n", i, cars[i].position, cars[i].direction, cars[i].currentLight);
    }
}

int main() {
    // Create an array of cars
    Car cars[NUM_CARS];

    // Initialize the cars
    for (int i = 0; i < NUM_CARS; i++) {
        cars[i].position = rand() % NUM_LANE;
        cars[i].direction = (enum CarDirection) rand() % 3;
        cars[i].currentLight = RED;
    }

    // Simulate traffic flow
    simulateTrafficFlow(cars);

    return 0;
}