//Falcon-180B DATASET v1.0 Category: Error handling ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAX_SIZE 100

typedef struct {
    int data[MAX_SIZE];
    int top;
} Stack;

void push(Stack* stack, int value) {
    if (stack->top == MAX_SIZE - 1) {
        printf("Stack Overflow!\n");
        exit(EXIT_FAILURE);
    }
    stack->data[++stack->top] = value;
}

int pop(Stack* stack) {
    if (stack->top == -1) {
        printf("Stack Underflow!\n");
        exit(EXIT_FAILURE);
    }
    return stack->data[stack->top--];
}

int peek(Stack* stack) {
    if (stack->top == -1) {
        printf("Stack is empty!\n");
        exit(EXIT_FAILURE);
    }
    return stack->data[stack->top];
}

int is_empty(Stack* stack) {
    return stack->top == -1;
}

int is_full(Stack* stack) {
    return stack->top == MAX_SIZE - 1;
}

int main() {
    Stack stack;
    stack.top = -1;

    push(&stack, 10);
    push(&stack, 20);
    push(&stack, 30);
    push(&stack, 40);

    printf("Top element is: %d\n", peek(&stack));

    pop(&stack);
    pop(&stack);

    printf("Top element after popping twice is: %d\n", peek(&stack));

    if (is_empty(&stack)) {
        printf("Stack is empty\n");
    } else {
        printf("Stack is not empty\n");
    }

    if (is_full(&stack)) {
        printf("Stack is full\n");
    } else {
        printf("Stack is not full\n");
    }

    return 0;
}