//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: authentic
#include <stdio.h>
#include <stdlib.h>

#define N 5 

// Function to check if x and y are valid indexes for N*N maze
int isSafe(int maze[N][N], int x, int y) {
    return (x >= 0 && x < N && y >= 0 && y < N && maze[x][y] == 1);
}

// Function to solve the maze using backtracking
int solveMazeUtil(int maze[N][N], int x, int y, int sol[N][N]) {
    // If we reach the bottom-right cell, return true
    if (x == N - 1 && y == N - 1) {
        sol[x][y] = 1;
        return 1;
    }

    // Check if maze[x][y] is valid
    if (isSafe(maze, x, y)) {
        // Mark x, y as part of solution path
        sol[x][y] = 1;

        // Move forward in x direction
        if (solveMazeUtil(maze, x + 1, y, sol))
            return 1;

        // If moving in x direction doesn't give solution then 
        // Move down in y direction
        if (solveMazeUtil(maze, x, y + 1, sol))
            return 1;

        // If none of the above movements work then 
        // BACKTRACK: unmark x, y as part of solution path
        sol[x][y] = 0;
        return 0;
    }

    return 0;
}

// Function to print the solution matrix
void printSolution(int sol[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            printf(" %d ", sol[i][j]);
        }
        printf("\n");
    }
}

// Function to solve the maze
int solveMaze(int maze[N][N]) {
    int sol[N][N];

    // Initialize the solution matrix
    for (int i = 0; i < N; i++)
        for (int j = 0; j < N; j++)
            sol[i][j] = 0;

    if (solveMazeUtil(maze, 0, 0, sol) == 0) {
        printf("No solution exists\n");
        return 0;
    }

    printSolution(sol);
    return 1;
}

// Main function
int main() {
    int maze[N][N] = {
        { 1, 0, 0, 0, 0 },
        { 1, 1, 0, 1, 0 },
        { 0, 1, 0, 0, 0 },
        { 0, 1, 1, 1, 1 },
        { 0, 0, 0, 0, 1 }
    };

    solveMaze(maze);
    return 0;
}