//Falcon-180B DATASET v1.0 Category: Procedural Space Adventure ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PLANETS 10
#define MAX_ALIENS 50
#define MAX_OBJECTS 100

typedef struct {
    int x, y;
} Vector2D;

typedef struct {
    char name[20];
    Vector2D position;
    int health;
    int attack;
} Alien;

typedef struct {
    char name[20];
    Vector2D position;
} Planet;

typedef struct {
    char name[20];
    Vector2D position;
    int value;
} Object;

void generatePlanets(Planet planets[], int numPlanets) {
    srand(time(NULL));

    for (int i = 0; i < numPlanets; i++) {
        planets[i].name[0] = 'P' + i;
        planets[i].position.x = rand() % 100;
        planets[i].position.y = rand() % 100;
    }
}

void generateAliens(Alien aliens[], int numAliens) {
    srand(time(NULL));

    for (int i = 0; i < numAliens; i++) {
        aliens[i].name[0] = 'A' + i;
        aliens[i].position.x = rand() % 100;
        aliens[i].position.y = rand() % 100;
        aliens[i].health = rand() % 100;
        aliens[i].attack = rand() % 100;
    }
}

void generateObjects(Object objects[], int numObjects) {
    srand(time(NULL));

    for (int i = 0; i < numObjects; i++) {
        objects[i].name[0] = 'O' + i;
        objects[i].position.x = rand() % 100;
        objects[i].position.y = rand() % 100;
        objects[i].value = rand() % 100;
    }
}

int main() {
    Planet planets[MAX_PLANETS];
    Alien aliens[MAX_ALIENS];
    Object objects[MAX_OBJECTS];

    int numPlanets = 5;
    int numAliens = 20;
    int numObjects = 30;

    generatePlanets(planets, numPlanets);
    generateAliens(aliens, numAliens);
    generateObjects(objects, numObjects);

    return 0;
}